; Tern (Terrain)                                     :
; a 64-byte intro by rrrola <rrrola@gmail.com>       :tt    NN
; greets to everyone who likes hiking         .    :tttttt  NN
;....       .                               ..:.t::tttteeE  NN
;tttt:..:..:..::                        . .t:tttteeRRtteeEE NNtee
;eRttteetReRRtttt: . .               . .:.:teRReRRRRRREENENNNNRee
;RReeRReRRRRRettttttttt..            ..teteeeRRRRRREEEENNENNNNNNN
;EEERRRRRRRRRRRetttttetttttt .   :  .:teeeRRRRRREEEEEENNNNNNNNNNN
;ENERERRERRRRRRReeeeeeeettttttt:tttt.ttRRRRERRREEEEENNNNNNNNNNNNN
;NNEEEEEEREERRRRRRRReReeeeteetetettttteRRREEEEENEENNNNNNNNNNNNNNN

org 100h   ; assume ds<=0x249f ah=0 si=0x100

;68 f6 9f
  push 0xa000 - 160/16
;34 13
  xor al,13h    ; ds=0x349f: texture segment
  pop es        ; es=0x9ff6: centered screen segment
  lds cx,[bx+si]; cx=0xf668: generate a lot of texture on init
  db 0xcd       ; int 0x10 (set 320x200 mode); hlt

;Texture: compute a row (256 texels) of 2D noise
;inspired by baze's texture generator from Tube, Lattice, Lander
T db 0x10,0xf4  ;=adc ah,dh  ; + random value (-16..15)
  adc ah,[si-127]; + top right neighbour [si-128+1]
  shr ah,1      ; average
  mov [si],ah   ; texel = (left + top_right + random + adc(0..2)) / 2
                ; the two "adc"s cause bias; good for ~2600 frames
  rcl dx,cl
  sar dx,3      ; next random value (-16..15), mess up top bits

  inc si        ; next texel: ah = left neighbour [si-1]
  loop T        ; si += 256; advance time

;Raymarch from the camera, compute the hit distance
;mul/imul trick from HellMood's Gespensterwald
R mov bh,7      ; bh=z (depth): 7..127 (7 prevents dithering underflow)
Z mov ax,0xcccd
  mul di        ; dh = unsigned y (0..200), dl = signed x (-128..128)
  mov al,dh
  mul bh        ; ah=y*z (unsigned because y can be > 127)
  xchg ax,dx    ; dh=y*z, al=x
  imul bh       ; ah=x*z (signed), al=fraction(x*z)
  mov bl,ah     ; bl=x*z
  cmp [bx+si],dh; hit if texture[x*z, z+time] <= y*z?
  jb D
  inc bh        ; no hit: z++
  jns Z

;Dithering, illusion of light from the right side
D aam 37        ; ah=al/37 ~~ 7*fraction(x*z)
  sub ah,bh     ; ah -= z_hit (128..255)
  shr ax,11     ; al=ah/8 (16..31: grayscale), ah=0

;Next pixel
  stosb
  loop R

;Next frame
;  call SCREENSHOT
  mov ch,1      ; use "mov ch,2" to fly faster
  jmp T         ; dx = last y*z (random value for next texel)

;%include "screenshot.inc"